<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet exclude-result-prefixes="hl7 xsi" version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:hl7="urn:hl7-org:v3"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output method="html"/>
	<xsl:template match="hl7:codeSystem">
		<html>
			<head>
				<title>
					<xsl:value-of select="hl7:name"/>
				</title>
				<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
				<script type="text/javascript" src="../css/gs_sortable.js"/>
				<script type="text/javascript">
                    var TSort_Data = new Array ('codeList', 's', 's', 's', 's', 's', 's', 's', 's', 's');
                    var TSort_Initial = 0;
                    var TSort_Classes = new Array ('plain', 'alternate');
                    tsRegister();
                </script>
				<link type="text/css" href="../css/nictiz.css" rel="stylesheet"/>
			</head>
			<body>
				<table width="100%">
					<tr>
						<td valign="bottom">
							<h1>
								<xsl:value-of select="hl7:name"/>
							</h1>
						</td>
						<td align="right">
							<div class="logo"/>
						</td>
					</tr>
				</table>
				<p/>
				<div class="content">
					<h2>
						<xsl:value-of select="hl7:code[1]/@codeSystem"/>
					</h2>
					<p/>
					<div class="level2">
						<xsl:value-of select="hl7:desc"/>
					</div>
					<p/>
					<table class="values" id="codeList">
						<thead>
							<tr>
								<th>Code</th>
								<th>Weergavenaam</th>
								<th>Trigger event</th>
								<th>Technische naam</th>
								<th>Vertrouwensniveau</th>
								<th>Gegevenssoort</th>
								<th>Verzendtype</th>
								<th>Vraagtype</th>
								<th>Actief</th>
							</tr>
						</thead>

						<xsl:for-each select="hl7:code">
							<tr>
								<xsl:if test="hl7:qualifier[@name='Actief']/@value='false'">
									<xsl:attribute name="style">
										<xsl:value-of select="'text-decoration: line-through;'"/>
									</xsl:attribute>
								</xsl:if>
								<td>
									<xsl:value-of select="@code"/>
								</td>
								<td>
									<xsl:value-of select="@displayName"/>
								</td>
								<td>
									<xsl:value-of select="hl7:reference[@root='2.16.840.1.113883.1.18']/@extension"/>
								</td>
								<td>
									<xsl:value-of select="hl7:originalText"/>
								</td>
								<td>
									<xsl:choose>
										<xsl:when test="hl7:qualifier[@name='Vertrouwensniveau']">
											<xsl:value-of select="hl7:qualifier[@name='Vertrouwensniveau']/@value"/>
										</xsl:when>
									</xsl:choose>
								</td>
								<td>
									<xsl:choose>
										<xsl:when test="hl7:qualifier[@name='Gegevenssoort']">
											<xsl:value-of select="hl7:qualifier[@name='Gegevenssoort']/@value"/>
										</xsl:when>
									</xsl:choose>
								</td>
								<td>
									<xsl:choose>
										<xsl:when test="hl7:qualifier[@name='Verzendtype']">
											<xsl:value-of select="hl7:qualifier[@name='Verzendtype']/@value"/>
										</xsl:when>
									</xsl:choose>
								</td>
								<td>
									<xsl:choose>
										<xsl:when test="hl7:qualifier[@name='Vraagtype']">
											<xsl:value-of select="hl7:qualifier[@name='Vraagtype']/@value"/>
										</xsl:when>
									</xsl:choose>
								</td>
								<td>
									<xsl:choose>
										<xsl:when test="hl7:qualifier[@name='Actief']">
											<xsl:value-of select="hl7:qualifier[@name='Actief']/@value"/>
										</xsl:when>
									</xsl:choose>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
